********************************************************************************
*****************DEBT AND CONSUMPTION - Spending Normalisation******************
*********************************DATE: MAY 2019 ********************************
***************************** AUTHOR: FIONA PRICE ******************************
*******************************************************************************
clear
set more off
use "C:\UnbalancedHH_analytical NEW.dta", replace
sort hhid0 wave

replace hdebtt = . if hdebtt!=. & own==1 & purchase==0 // missing if don't have information on when they purchased property

*************
***TABLE 1***
*************
mat Table5 = J(11,3,.)
mat rown Table5 = Debtcoeff Debtpv Lconsump Lconsumppv Changecoeff Changepv Inccoeff Incpv Hpcoeff Hppv Obs
mat coln Table5 = DynamicAB TotalFE TotalIV

//set up list of control variables for model
local controlvars inct L.hp1t i.agewmax i.educ kids hhadult married unemp nilf L.dhdebtt
local controlvarsD inct Lhp1t i.agewmax i.educ kids hhadult married unemp nilf 

//set up debt measure for model
local debtvar hdebtt

/// 1. Dynamic model - AB estimation
xi: xtabond consumpt L`debtvar' `controlvarsD' if L.`debtvar'>0 & L.`debtvar'!=. & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10, lags(1) vce(robust) endogenous(L`debtvar')
mat Table5[1,1]=_b[L`debtvar']
mat Table5[2,1]=(2 * ttail(e(df_m), abs(_b[L`debtvar']/_se[L`debtvar'])))
mat Table5[3,1]=_b[L.consumpt]
mat Table5[4,1]=(2 * ttail(e(df_m), abs(_b[L.consumpt]/_se[L.consumpt])))
mat Table5[7,1]=_b[inct]
mat Table5[8,1]=(2 * ttail(e(df_m), abs(_b[inct]/_se[inct])))
mat Table5[9,1]=_b[Lhp1t]
mat Table5[10,1]=(2 * ttail(e(df_m), abs(_b[Lhp1t]/_se[Lhp1t])))
mat Table5[11,1]=e(N)


///2.  OLS Model with HH FE 
 xtreg consumpt `controlvars' L.`debtvar' if L.`debtvar'>0 & touse==1 & touse2==1 & touse3==1  & wave>=6 & wave<=10,  fe cluster(hhid0) robust
mat Table5[1,2]=_b[L.`debtvar']
mat Table5[2,2]=(2 * ttail(e(df_r), abs(_b[L.`debtvar']/_se[L.`debtvar'])))
mat Table5[5,2]=_b[L.dhdebtt]
mat Table5[6,2]=(2 * ttail(e(df_r), abs(_b[L.dhdebtt]/_se[L.dhdebtt])))
mat Table5[7,2]=_b[inct]
mat Table5[8,2]=(2 * ttail(e(df_r), abs(_b[inct]/_se[inct])))
mat Table5[9,2]=_b[L.hp1t]
mat Table5[10,2]=(2 * ttail(e(df_r), abs(_b[L.hp1t]/_se[L.hp1t])))
mat Table5[11,2]=e(N)


///3. IV with postcode FE
drop Lhdebtt 
gen L`debtvar'=L.`debtvar'
local controlvars inct Lhp1t i.agewmax i.educ kids hhadult married unemp nilf Ldhdebtt

** Change panel variable from household to postcode
xtset, clear
xtset postcode
xtivreg consumpt `controlvars' (L`debtvar'  =  Lpostboom) if L`debtvar'>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10, fe first 
mat Table5[1,3]=_b[L`debtvar']
mat Table5[2,3]=(2 * ttail(e(df_rz), abs(_b[L`debtvar']/_se[L`debtvar'])))
mat Table5[5,3]=_b[Ldhdebtt]
mat Table5[6,3]=(2 * ttail(e(df_rz), abs(_b[Ldhdebtt]/_se[Ldhdebtt])))
mat Table5[7,3]=_b[inct]
mat Table5[8,3]=(2 * ttail(e(df_rz), abs(_b[inct]/_se[inct])))
mat Table5[9,3]=_b[Lhp1t]
mat Table5[10,3]=(2 * ttail(e(df_rz), abs(_b[Lhp1t]/_se[Lhp1t])))
mat Table5[11,3]=e(N)

** Change panel variable back to household from postcode
xtset, clear
xtset hhid0 wave

/// show results for all models
matlist Table5 
